/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.html;

import icyllis.flexmark.util.html.Attribute;
import icyllis.flexmark.util.html.MutableAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class Attributes {
    public static final Attributes EMPTY = new Attributes();
    protected LinkedHashMap<String, Attribute> attributes;

    public Attributes() {
        this.attributes = null;
    }

    public Attributes(Attributes attributes) {
        this.attributes = attributes == null || attributes.attributes == null ? null : new LinkedHashMap<String, Attribute>(attributes.attributes);
    }

    public MutableAttributes toMutable() {
        return new MutableAttributes(this);
    }

    public Attributes toImmutable() {
        return this;
    }

    public Attribute get(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        return this.attributes.get(useKey);
    }

    public String getValue(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return "";
        }
        String useKey = String.valueOf(key);
        Attribute attribute = this.attributes.get(useKey);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }

    public boolean contains(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return false;
        }
        String useKey = String.valueOf(key);
        return this.attributes.containsKey(useKey);
    }

    public boolean containsValue(CharSequence key, CharSequence value) {
        if (this.attributes == null) {
            return false;
        }
        String useKey = String.valueOf(key);
        Attribute attribute = this.attributes.get(useKey);
        return attribute != null && attribute.containsValue(value);
    }

    public boolean isEmpty() {
        return this.attributes == null || this.attributes.isEmpty();
    }

    public Set<String> keySet() {
        return this.attributes != null ? this.attributes.keySet() : Collections.EMPTY_SET;
    }

    public Collection<Attribute> values() {
        return this.attributes != null ? this.attributes.values() : Collections.EMPTY_LIST;
    }

    public Set<Map.Entry<String, Attribute>> entrySet() {
        return this.attributes != null ? this.attributes.entrySet() : Collections.EMPTY_SET;
    }

    public void forEach(BiConsumer<String, Attribute> action) {
        if (this.attributes != null) {
            for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
                action.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public int size() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String attrName : this.keySet()) {
            sb.append(sep).append(attrName);
            Attribute attribute = this.attributes.get(attrName);
            if (!attribute.getValue().isEmpty()) {
                sb.append("=").append("\"").append(attribute.getValue().replace("\"", "\\\"")).append("\"");
            }
            sep = " ";
        }
        return "Attributes{" + sb.toString() + '}';
    }
}

